<?php
/*
 * Template file for projects shortcode.
 * $temptt_t_vars is an array of custom parameters set for given post shortcode.
 */

?>
<div class="project-homefull">
	<div class="thm-container">
		<div class="title">
			<h3><?php echo esc_attr($temptt_t_vars['temptt_var2']); ?></h3>
		</div>
<?php
// Posts are found
if ( $posts->have_posts() ) {
	if($temptt_t_vars['temptt_show_filters'] == 'yes' ) {
	                $sub_cat_args = array('hide_empty' => 0, 'orderby' => 'ID');
	                $sub_cat_terms = get_terms('tt_project_cats', $sub_cat_args);
	                if (!empty($sub_cat_terms) && !is_wp_error($sub_cat_terms)) { ?>

		<div class="gallery-filter">
			<ul class="post-filter masonary">
				<?php if($temptt_t_vars['temptt_filter_all'] == 'yes' ) { ?>
			     <li class="filter active" data-filter=".masonary-item"><span><?php esc_html_e('All', 'ranbron');?></span></li>
				<?php } ?>
	            <?php foreach ($sub_cat_terms as $sub_cat) {
                print '<li class="filter " data-filter=".' . $sub_cat->slug . '"><span>' . $sub_cat->name . '</span></li>';
			    } ?>
			</ul><!-- /.post-filter -->
		</div><!-- /.gallery-filter -->
	                <?php }
	} ?>
	</div><!-- /.thm-container -->

	<div class="masonary-layout <?php if($temptt_t_vars['temptt_show_filters'] == 'yes' ) echo ' filter-layout ';?> thm-container-fluid" data-filter-class="filter">
	<?php
	while ( $posts->have_posts() ) :
		$posts->the_post();
		global $post;
	            $curent_term_array = wp_get_post_terms(get_the_ID(), 'tt_project_cats');
	            $current_term_string = '';
	            foreach ($curent_term_array as $curent_term_item) {
	                $current_term_string .= ' ' . $curent_term_item->slug;

	            }
		?>
		<div class="span-5 <?php if($temptt_t_vars['temptt_show_filters'] == 'yes' ) echo esc_attr($current_term_string);?> masonary-item single-filter-item ">
			<div class="single-project-item">
	            <?php if ( has_post_thumbnail() ) : ?>
					<div class="img-box">
						<?php the_post_thumbnail(array('348','255')); ?>
						<div class="overlay">
							<div class="box">
								<div class="content">
									<a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/5.png"  /></a>
								</div><!-- /.content -->
							</div><!-- /.box -->
						</div><!-- /.overlay -->
					</div><!-- /.img-box -->
				<?php endif; ?>
				<div class="text-box text-center">
					<?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
					<p><?php the_excerpt(); ?></p>
				</div><!-- /.text-box -->
			</div><!-- /.single-project-item -->
		</div><!-- /.span-5 -->
	<?php
	endwhile; ?>
	<?php
	}
	// Posts not found
	else {
		echo '<h4>' . esc_html__( 'Posts not found', 'ranbron' ) . '</h4>';
	}
	?>
	</div><!-- /.thm-container-fluid -->
</div><!-- /.project-area -->

