<?php
/*
 * ranbron.com
 *
 * Banner with label slider for VC
 *
 */

function tt_vc_service_fn_vc() {
    vc_map(
        array(
            'name'                    => esc_html__( 'Ranbron Service Block' , 'ranbron' ),
            'base'                    => 'tt_vc_service_shortcode',
			"icon"     => 'tt-vc-block',
            'description'             => esc_html__( 'Service block for this theme.', 'ranbron' ),
            "category" => esc_html__('Ranbron', 'ranbron'),
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Insert Graphic", 'ranbron'),
					'description' => esc_html__( 'Do you want to insert image or icon on this infobox.', 'ranbron' ),
					"param_name" => "insert_graphic",
					"value" => array(
						'No' => 'no',
						'Image only' => 'image',
						'Icon only' => 'icon',
					)
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'ranbron' ),
					'param_name' => 'icon1',
					'value' => 'fa fa-adjust', // default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display, we use (big number) to display all icons in single page
					),
					'description' => esc_html__( 'Select icon from library.', 'ranbron' ),
					'dependency' => array(
						'element' => 'insert_graphic',
						'value' => 'icon',
					),
				),
				array(
					'type' => 'attach_image',
					'heading' => esc_html__( 'Image', 'ranbron' ),
					'param_name' => 'image',
					'value' => '',
					'description' => esc_html__( 'Select image from media library.', 'ranbron' ),
					'dependency' => array(
						'element' => 'insert_graphic',
						'value' => 'image',
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Image size', 'ranbron' ),
					'param_name' => 'img_size',
					'value' => 'thumbnail',
					'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).', 'ranbron' ),
					'dependency' => array(
						'element' => 'insert_graphic',
						'value' => array( 'image', 'featured_image' ),
					),
				),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'Title', 'ranbron' ),
                    'param_name'  => 'title',
                    'admin_label' => true,
                    'value'       => '',
                ),
                array(
                    'type'        => 'textarea_html',
                    'heading'     => esc_html__( 'Description', 'ranbron' ),
                    'param_name'  => 'content',
                    'value'       => '',
                ),
				array(
					"type" => "vc_link",
					"class" => "",
					"heading" => esc_html__("Link",'ranbron'),
					"description" => esc_html__("If you want a link on the bottom, enter anchor text and link here. Leave as it is for no link.",'ranbron'),
					"param_name" => "btn_link",
					"value" => "",
			    ),
/*				array(
					"type" => "dropdown",
					"heading" => esc_html__("Type", 'ranbron'),
					'description' => esc_html__( 'Type 2 is used on homepage 4.', 'ranbron' ),
					"param_name" => "type",
					"value" => array(
						'Default' => 'default',
						'Type 2' => 'type2',
					)
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Background Style.", 'ranbron'),
					"param_name" => "bgtype",
					"value" => array(
						'Default' => 'bg-dark',
						'Dark'    => 'bg-light',
					),
					'dependency' => array(
						'element' => 'type',
						'value' => array( 'type2' ),
					),
				),*/
			),
        )
    );
}
add_action( 'vc_before_init', 'tt_vc_service_fn_vc' );
// A must for container functionality, replace Wbc_Item with your base name from mapping for parent container
if(class_exists('WPBakeryShortCode')){
    class WPBakeryShortCode_tt_vc_service_shortcode extends WPBakeryShortCode {

    }
}
