<?php
/*
 * Templatation.com
 *
 *
 */

function tt_vc_add_content_fn_vc() {
    vc_map(
        array(
            'name'                    => esc_html__( 'Add Content' , 'ranbron' ),
            'base'                    => 'tt_vc_add_content_shortcode',
			"icon"     => 'tt-vc-block',
            'description'             => esc_html__( 'Add various content objects.', 'ranbron' ),
            "category" => esc_html__('Ranbron', 'ranbron'),
			"params" => array(

		                array(
							'type'			=> 'textfield',
							'heading'			=> esc_html__( 'Number of posts displayed', 'ranbron' ),
							'param_name'			=> 'posts_per_page',
							'description'	=> esc_html__( 'The number of posts you want to show.', 'ranbron' ),
							'value'			=> '5',
							'admin_label'	=> true,
						),
						array(
							'type'			=> 'dropdown',
							'heading'		=> esc_html__( 'Content Type', 'ranbron' ),
							'param_name'	=> 'post_type',
							'description'	=> esc_html__( 'Not all content type will be listed here. We list only those we have template in this theme for.', 'ranbron' ),
							'admin_label'	=> true,
							'value' 		=> array(
								esc_html__(' Posts', 'ranbron')         =>  'post',
								esc_html__(' Testimonials', 'ranbron')  =>  'tt_testimonial',
								esc_html__(' Services', 'ranbron')      =>  'tt_portfolio',
								esc_html__(' Cases', 'ranbron')         =>  'tt_project',
							)
						),
						array(
							'param_name' => 'enable_filter',
							'heading' => esc_html__( 'Enable Filter ?', 'ranbron' ),
							'type' => 'checkbox',
							'description' => esc_html__( 'If set to yes, the gallery is filterable by the category. Not applicable to all cases. Not applicable on all templates.', 'ranbron' ),
							'value'	=> 'true',
							'dependency' => array(
								'element'   => 'post_type',
								'value'     => 'tt_project',
							),
						),
						array(
							'param_name' => 'enable_all_btn',
							'heading' => esc_html__( 'Enable ALL button ?', 'ranbron' ),
							'type' => 'checkbox',
							'description' => esc_html__( 'If set to yes, All link appears first that displays all items. Not applicable to all cases. Not applicable on all templates.', 'ranbron' ),
							'value'	=> 'true',
							'dependency' => array(
								'element'   => 'post_type',
								'value'     => 'tt_project',
							),
						),
						array(
							'type'			=> 'dropdown',
							'heading'		=> esc_html__( 'Order by', 'ranbron' ),
							'param_name'	=> 'orderby',
							'description'	=> esc_html__( '', 'ranbron' ),
							'value' 		=> array(
								esc_html__(' Date', 'ranbron')		                => 'date',
								esc_html__(' Post ID', 'ranbron')		            => 'ID',
								esc_html__(' Author', 'ranbron')	                => 'author',
								esc_html__(' Title', 'ranbron')	                    => 'title',
								esc_html__(' Post name (post slug)', 'ranbron')		=> 'name',
								esc_html__(' Last modified date', 'ranbron')	    => 'modified',
								esc_html__(' Random order', 'ranbron')	            => 'rand',
								esc_html__(' Number of comments', 'ranbron') 	    => 'comment_count',
							)
						),
						array(
							'type'			=> 'dropdown',
							'heading'		=> esc_html__( 'Order post', 'ranbron' ),
							'param_name'	=> 'tt_order',
							'value' 		=> array(
								esc_html__(' DESC', 'ranbron')		=> 'DESC',
								esc_html__(' ASC', 'ranbron')	    => 'ASC',
							)
						),
						array(
							'type'			=> 'text',
							'heading'			=> esc_html__( 'Post Ids', 'ranbron' ),
							'param_name'			=> 'tt_id',
							'description'	=> esc_html__( 'If you want to display particular posts, enter their IDs comma separated. eg 101,202,300. Recommended: Leave blank', 'ranbron' ),
							'admin_label'	=> true,
						),
						array(
							'type'			=> 'dropdown',
							'heading'			=> esc_html__( 'Display Template', 'ranbron' ),
							'param_name'			=> 'tt_template',
							'description'	=> esc_html__( 'There are prebuilt templates to display certain content in this theme. You are requested not to edit this.', 'ranbron' ),
							'value' 		=> array(
								esc_html__(' Default', 'ranbron')	                => 'default',
								esc_html__(' Posts Title Only', 'ranbron')	        => 'posttitleonly',
								esc_html__(' Testimonial Carousel', 'ranbron')	    => 'testimonial',
								esc_html__(' Testimonial Carousel 2', 'ranbron')	=> 'testimonial2',
								esc_html__(' Testimonial List', 'ranbron')	        => 'testimonial_list',
								esc_html__(' Service Carousel', 'ranbron')	        => 'service_carousel',
								esc_html__(' Service List', 'ranbron')	            => 'service_list',
								esc_html__(' Service List 2', 'ranbron')	        => 'service_list2',
								esc_html__(' Case List', 'ranbron')	                => 'case_list',
								esc_html__(' Case Carousel', 'ranbron')	            => 'case_carousel',
							)
						),
		                array(
							'type'			=> 'textfield',
							'heading'		=> esc_html__( 'Case section Title', 'ranbron' ),
							'param_name'	=> 'case_title',
							'description'	=> esc_html__( 'This is used as title for this carousel.', 'ranbron' ),
							'value'			=> 'OUR CASES',
							'dependency' => array(
								'element'   => 'tt_template',
								'value'     => 'case_carousel',
							),
						),
		                array(
							'type'			=> 'textarea',
							'heading'		=> esc_html__( 'Case section Description', 'ranbron' ),
							'param_name'	=> 'case_desc',
							'description'	=> esc_html__( 'This is used as Description for this carousel.', 'ranbron' ),
							'dependency' => array(
								'element'   => 'tt_template',
								'value'     => 'case_carousel',
							),
						),
	                )
        )
    );
}
add_action( 'vc_before_init', 'tt_vc_add_content_fn_vc' );
// A must for container functionality, replace Wbc_Item with your base name from mapping for parent container
if(class_exists('WPBakeryShortCode')){
    class WPBakeryShortCode_tt_vc_add_content_shortcode extends WPBakeryShortCode {

    }
}
