<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/*-----------------------------------------------------------------------------------
 *
 * This file contains required functions for the theme.
 * @templatation.com
 *
-----------------------------------------------------------------------------------*/

add_action( 'wp_head', 'ranbron_tt_wp_head', 9 );
if ( ! function_exists( 'ranbron_tt_wp_head' ) ) {
/**
 * Output the default ttFramework "head" markup in the "head" section.
 * @since  2.0.0
 * @return void
 */
function ranbron_tt_wp_head() {
	do_action( 'ranbron_tt_wp_head_before' );

	// Output custom favicon icons
	if ( function_exists( 'ranbron_tt_custom_favicon' ) && ! function_exists( 'wp_site_icon' ) )
		ranbron_tt_custom_favicon();

	do_action( 'ranbron_tt_wp_head_after' );
} // End ranbron_tt_wp_head()
}

/*-----------------------------------------------------------------------------------*/
/* tt_get_dynamic_value() */
/* Replace values in a provided array with theme options, if available. */
/*
/* $settings array should resemble: $settings = array( 'theme_option_without_tt' => 'default_value' );
/*
/* @since 4.4.4 */
/*-----------------------------------------------------------------------------------*/
if( !function_exists( 'ranbron_fw_opt_values' )) {
	function ranbron_fw_opt_values( $settings ) {
		global $tt_temptt_opt;

		if ( is_array( $tt_temptt_opt ) ) {
			foreach ( $settings as $k => $v ) {

				if ( is_array( $v ) ) {
					foreach ( $v as $k1 => $v1 ) {
						if ( isset( $tt_temptt_opt[ 'tt_' . $k ][ $k1 ] ) && ( $tt_temptt_opt[ 'tt_' . $k ][ $k1 ] != '' ) ) {
							$settings[ $k ][ $k1 ] = $tt_temptt_opt[ 'tt_' . $k ][ $k1 ];
						}
					}
				} else {
					if ( isset( $tt_temptt_opt[ 'tt_' . $k ] ) && ( $tt_temptt_opt[ 'tt_' . $k ] != '' ) ) {
						$settings[ $k ] = $tt_temptt_opt[ 'tt_' . $k ];
					}
				}
			}
		}

		return $settings;
	} // End ranbron_fw_opt_values()
}


/*-----------------------------------------------------------------------------------*/
/* ranbron_fw_get_option() */
/* Replace values in a provided variable with theme options, if available. */
/*
 * field id should be without tt_
 */
/* TT @since 6.0 */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_fw_get_option' ) ) {
	function ranbron_fw_get_option( $var, $default = false ) {
		global $tt_temptt_opt;

		if ( isset( $tt_temptt_opt[ 'tt_' . $var ] ) ) {
			$var = $tt_temptt_opt[ 'tt_' . $var ];
		} else {
			$var = $default;
		}

		return $var;
	} // End ranbron_fw_get_option()
}

/*-----------------------------------------------------------------------------------*/
/* Header Type
/*-----------------------------------------------------------------------------------*/

if (!function_exists( 'ranbron_get_hdr_type')) {
	function ranbron_get_hdr_type() {

	$single_data2 = $tt_post_id = $hdr_type = $single_hdr_type = '';
	// grab value from themeoptions
	$hdr_type = ranbron_fw_get_option( 'header_layout', 'default' );
	$tt_post_id = ranbron_get_the_id();
	if( isset($tt_post_id) ) $single_data2 = get_post_meta( $tt_post_id, '_tt_meta_page_opt', true );
	if( is_array($single_data2) ) {
		if ( isset( $single_data2['_single_hdr_type'] ) ) $single_hdr_type = $single_data2['_single_hdr_type'];
	}
	if( $single_hdr_type == 'default' || $single_hdr_type == 'header1' || $single_hdr_type == 'header2' || $single_hdr_type == 'header3' || $single_hdr_type == 'header4' || $single_hdr_type == 'header5' ) $hdr_type = $single_hdr_type;

		return $hdr_type;
	}
}

/*-----------------------------------------------------------------------------------*/
/* Adds custom classes to the array of body classes.
/*-----------------------------------------------------------------------------------*/
/**
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function ranbron_body_classes( $classes ) {

	global $tt_temptt_opt, $wp_query;
	$current_page_template = $hdr_type = $single_data2 = $tt_post_id = $single_enable_headline = $single_no_tpad = $single_no_bpad = '';

	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	if ( !is_404() && !is_search() ) {
		if ( ! empty( $wp_query->post->ID ) ) {
			$tt_post_id = $wp_query->post->ID;
		}
	}
	if(is_home()) $tt_post_id = get_option( 'page_for_posts' );

	$single_data2 = get_post_meta( $tt_post_id, '_tt_meta_page_opt', true );
	if( is_array($single_data2) ) {
		if ( isset( $single_data2['_single_enable_headline'] ) ) $single_enable_headline = $single_data2['_single_enable_headline'];
		if ( isset( $single_data2['_single_enable_bpadding'] ) ) $single_enable_bpadding = $single_data2['_single_enable_bpadding'];
		if ( isset( $single_data2['_single_enable_tpadding'] ) ) $single_enable_tpadding = $single_data2['_single_enable_tpadding'];
		if ( isset( $single_data2['_single_no_tpad'] ) ) $single_no_tpad = $single_data2['_single_no_tpad'];
		if ( isset( $single_data2['_single_no_bpad'] ) ) $single_no_bpad = $single_data2['_single_no_bpad'];
	}
	// setting defaults
	if ( !is_page() && (!isset($single_enable_headline) || empty($single_enable_headline)) ) $single_enable_headline = false;
	if ( !isset($single_enable_bpadding) ) $single_enable_bpadding = true;
	if ( !isset($single_enable_tpadding) ) $single_enable_tpadding = true;
	( $single_enable_headline ) ?  $classes[] = 'hdline_set' : $classes[] = 'no_hdline';
	if ( ! $single_enable_bpadding ) { $classes[] = 'no-bpadd'; }
	if( !defined('TT_FW_ROOT')) { $classes[] = 'no-ttfmrk'; }
	if ( $single_no_tpad == '1' ) { $classes[] = 'no-tpadd'; }
	if ( $single_no_bpad == '1' ) { $classes[] = 'no-bpadd'; }
	$hdr_type = ranbron_get_hdr_type();
	$classes[] = 'hdr-'.$hdr_type;
	// Removes tag class from the body_class array to avoid Bootstrap markup styling issues.
    foreach ( $classes as $key => $value ) {
        if ( $value == 'tag' ) unset( $classes[ $key ] );
    }

	return $classes;
}
add_filter( 'body_class', 'ranbron_body_classes' );




/*-----------------------------------------------------------------------------------*/
/* Post/page title
/*-----------------------------------------------------------------------------------*/
// returns title based on the requirement.

if (!function_exists( 'ranbron_fw_post_title')) {
function ranbron_fw_post_title( $tag='' ){

	global $wp_query;
	$tt_post_id = $single_item_layout = $tt_lay_content = $tt_lay_sidebar = $single_data2 = '';
	if( empty($tag)) $tag = 'h3';

		if ( ! is_404() && ! is_search() ) {
			if ( ! empty( $wp_query->post->ID ) ) {
				$tt_post_id = $wp_query->post->ID;
			}
		}
		if ( ! empty( $tt_post_id ) ) {
			$single_data2 = get_post_meta( $tt_post_id, '_tt_meta_page_opt', true );
		}

		/* if hero area is enabled(or if its not set), we do not need title display */
		if ( is_array( $single_data2 ) ) {
			if ( $single_data2['_single_enable_headline'] && is_page() ) {
				return '';
			}
		}

		if ( is_array( $single_data2 ) ) {
			if ( $single_data2['_hide_title_display'] ) {
				return '';
			}
		}

	return the_title( '<header class="entry-header"><'.$tag.' class="entry-title page-title">', '</'.$tag.'></header>' );
	//return '<div class="single-bolg-title"><'.$tag. ' class="page-title ml-title">'. get_the_title() .'</'.$tag.'></div>';
}
}

/*-----------------------------------------------------------------------------------*/
/* Load custom logo. */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_fw_logo' ) ) {
function ranbron_fw_logo ( $type='' ) {
	global $tt_temptt_opt, $wp_query;
	$tt_post_id = $single_data2 = $width = $height = $style = $logo = $single_logo_setting = '';
	if ( !is_404() && !is_search() ) {
		if ( ! empty( $wp_query->post->ID ) ) {
			$tt_post_id = $wp_query->post->ID;
		}
	}

	$settingsl = array(
					'retina_favicon' => '0',
					'retina_favicon2' => '0',
					'logo' => '',
					'logo2' => '',
					'retina_logo_wh' => '',
					'retina_logo_wh2' => '',
				);
	$settingsl = ranbron_fw_opt_values( $settingsl );
	if ( '2' == $type ) {
		$logo = esc_url( RANBRON_THEME_DIRURI . 'assets/img/ranlogo.jpg' ); // default logo from theme image folder.
	} else {
		$logo = esc_url( RANBRON_THEME_DIRURI . 'assets/img/header-logo.png' ); // default logo from theme image folder.
	}
	$logo2 = esc_url( RANBRON_THEME_DIRURI . 'assets/img/stick-logo.png' ); // default logo from theme image folder.
	if ( !empty( $settingsl['logo']['url'] ) ) { $logo = $settingsl['logo']['url'] ; }
	if ( !empty( $settingsl['logo2']['url'] ) ) { $logo2 = $settingsl['logo2']['url'] ; }
	if ( is_ssl() ) { $logo = str_replace( 'http://', 'https://', $logo ); }
	ob_start();
?>

	<a class="logo navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'description' ) ); ?>">
		<img src="<?php echo esc_url( $logo ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" />
	</a>
<?php
	return ob_get_clean();
} // End ranbron_fw_logo()
}

/*-----------------------------------------------------------------------------------*/
/* Fetch ALT tags for images
/*-----------------------------------------------------------------------------------*/
// returns title based on the requirement.

if (!function_exists( 'ranbron_fw_img_alt')) {
function ranbron_fw_img_alt( $imgid = '', $postid = '' ){
$alt = '';
if( '' == $imgid && '' != $postid ) // if only post id is given, fetch imgid from it.
$imgid = get_post_thumbnail_id( $postid );

if($imgid) $alt = get_post_meta( $imgid, '_wp_attachment_image_alt', true);

return htmlspecialchars($alt);

}
}

/*-----------------------------------------------------------------------------------*/
/* Topnav function */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_topnav_content' ) ) {
function ranbron_topnav_content ($class='') {

	if ( ranbron_fw_get_option( 'enable_topbar', 0 ) == '0' ) return; // do nothing if top nav bar is disabled in themeoptions.
	//$hdr_type = ranbron_get_hdr_type();
	$hdr_type = 'default';
	//$header3_topbar = ranbron_fw_get_option( 'header3_topbar', '1');

	//if ( $hdr_type == 'header3' && $header3_topbar == '1' ) {
/*
	if ( $hdr_type == 'default' ) {
	ob_start(); ?>
		<div class="top-bar-home-two">
    		<div class="thm-container clearfix">
    			<div class="left-contact-info pull-left">
    				<ul class="list-inline">
			<?php if ( '' != ranbron_fw_get_option('contact_number') ) { ?>
				<li><p><a href="tel:<?php echo preg_replace('/(\W*)/', '', ranbron_fw_get_option('contact_number')); ?>"><i class="fa fa-phone"></i><?php echo esc_html(ranbron_fw_get_option('contact_number')); ?></a></p></li>
			<?php } ?>
			<?php if ( '' != ranbron_fw_get_option('contactform_email') ) { ?>
				<li><p><a href="mailto:<?php echo sanitize_email(ranbron_fw_get_option('contactform_email')); ?>"><i class="fa fa-envelope-o" ></i><?php echo sanitize_email(ranbron_fw_get_option('contactform_email')); ?></a></p></li>
			<?php } ?>
    					<li><p><i class="icon icon-Timer"></i> <?php echo esc_textarea(ranbron_fw_get_option('hdr_opentiming1')); ?></p></li>
    				</ul><!-- /.list-inline -->
    			</div><!-- /.left-contact-info -->
    			<div class="right-social pull-right">
    				<?php get_template_part('templates/tt-social'); ?>
    			</div><!-- /.right-contact-info pull-right -->
    		</div><!-- /.thm-container -->
    	</div>


<?php $output = ob_get_clean();
	return  $output;
	}
*/
	if($class == '') $class = 'top-bar';
	// Fetch left side content
	$top_nav_left_layout = ranbron_fw_get_option('top_nav_left_layout', '');
	$nav_left_layout = $top_nav_left_layout['enabled'];

	// Fetch right side content
	$top_nav_right_layout = ranbron_fw_get_option('top_nav_right_layout', '');
	$nav_right_layout = $top_nav_right_layout['enabled'];

$output = '
	<div class="hdr_top_bar ' .$class. '">
		<div class="thm-container clearfix">';

$output .= '
	<!-- Start left side content -->
	<div class="left-content pull-left">';
	$output .= ranbron_topnav_content_render( $nav_left_layout );
	$output .=
	'</div><!-- .left-content -->';

$output .= '
	<!-- Start right side content -->
	<div class="right-content pull-right">';
	$output .= ranbron_topnav_content_render( $nav_right_layout );
	$output .=
	'</div><!-- .right-content -->';

$output .= '
	</div>
</div>';

	return  $output;
} // End ranbron_topnav_content()
}


/*-----------------------------------------------------------------------------------*/
/* Topnav render function */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_topnav_content_render' ) ) {
function ranbron_topnav_content_render ( $nav_layout = null ) {
	$output =  "";
	$topsettings = array(
					'enable_topbar'         => '1',
					'ttext_icon'            => '',
					'ttext_text'            => '',
					'contact_number'        => '',
					'contactform_email'     => '',
					'top_nav_menu'          => '',
					'top_nav_email_icon'    => '1',
					'top_nav_phone_icon'    => '1',
					);

	$topsettings = ranbron_fw_opt_values( $topsettings );

ob_start();

// available content blocks.
// email, text_icon, text, phone_icon, phone, wpml_lang, search, social

if ($nav_layout): foreach ($nav_layout as $key=>$value) {

    switch($key) {

        case 'email':

			if ( !empty( $topsettings['contactform_email'] )) { ?>
			<span>
				<a href="mailto:<?php echo sanitize_email($topsettings['contactform_email']); ?>"><i class="fa fa-envelope-o"></i><?php echo sanitize_email($topsettings['contactform_email']); ?></a>
			</span>
			<?php }


        break;

        case 'teaser_text':

			if ( $topsettings['ttext_text'] != '' ) { echo '<span class="tt-top-teaser">'. stripslashes( esc_attr( $topsettings['ttext_text'] )) .'</span>';  }

        break;

        case 'phone':

			if ( !empty( $topsettings['contact_number'] )) { ?>
			<span>
				<a href="tel:<?php echo preg_replace('/(\W*)/', '', $topsettings['contact_number']); ?>"><i class="fa fa-phone"></i><?php echo esc_attr($topsettings['contact_number']); ?></a>
			</span>
			<?php }

        break;

        case 'spacer':

		            ?>
	                <div class="topnav-spacer"></div>
	        <?php

        break;

        case 'spacer2':

		            ?>
	                <div class="topnav-spacer"></div>
	        <?php

        break;

        case 'wpml_lang':

						do_action('icl_language_selector');

        break;

        case 'custommenu':

		            if ( !empty( $topsettings['top_nav_menu'] ) ) {
		                wp_nav_menu( array( 'depth'          => 1,
		                                    'sort_column'    => 'menu_order',
		                                    'container'      => 'ul',
		                                    'menu_class'     => 'top-nav sup-nav',
		                                    'menu'        => $topsettings['top_nav_menu'],
		                ) );
		            }

        break;

        case 'social':
					?>
					<div class="social-icons">
						<?php get_template_part( 'templates/tt-social' ); ?>
					</div>
					<?php
        break;

    }

}

endif;

	$output = ob_get_clean();
	return $output;

} //ranbron_topnav_content_render
}

/*-----------------------------------------------------------------------------------*/
/* return excerpt with given charlent.                                               */
/*-----------------------------------------------------------------------------------*/
// source https://codex.wordpress.org/Function_Reference/get_the_excerpt
if (!function_exists( 'ranbron_tt_excerpt_charlength')) {
	function ranbron_tt_excerpt_charlength( $charlength ) {
		$excerpt = get_the_excerpt();
		$charlength ++;

		if ( mb_strlen( $excerpt ) > $charlength ) {
			$subex   = mb_substr( $excerpt, 0, $charlength - 5 );
			$exwords = explode( ' ', $subex );
			$excut   = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
			if ( $excut < 0 ) {
				echo mb_substr( $subex, 0, $excut );
			} else {
				echo esc_attr($subex);
			}
			echo '...';
		} else {
			echo esc_attr($excerpt);
		}
	}
}

/*-----------------------------------------------------------------------------------*/
/* Misc small functions for visuals.                                                 */
/*-----------------------------------------------------------------------------------*/
// Adding span tag in category widgets for styling purpose
add_filter('wp_list_categories', 'ranbron_tt_cat_count');
function ranbron_tt_cat_count($links) {
  $links = str_replace('</a> (', ' <span>(', $links);
  $links = str_replace(')', ')</span></a>', $links);
  return $links;
}


// adding filter to add class in previous/next post button.
add_filter('next_post_link', 'ranbron_tt_post_link_attr');
add_filter('previous_post_link', 'ranbron_tt_post_link_attr');
function ranbron_tt_post_link_attr($output) {
    $injection = 'class="button"';
    return str_replace('<a href=', '<a '.$injection.' href=', $output);
}


/*-----------------------------------------------------------------------------------*/
/* Getting the ID of the page                                                     */
/*-----------------------------------------------------------------------------------*/

if( !function_exists('ranbron_get_the_id') ) {
	function ranbron_get_the_id() {
		global $wp_query;
		$tt_post_id = '';
		if ( is_404() || is_search() ) {
			return '';
		}
		if ( isset( $wp_query->post->ID ) ) {
			$tt_post_id = $wp_query->post->ID;
		}
		if ( is_home() ) {
			$tt_post_id = get_option( 'page_for_posts' );
		}
		if ( class_exists( 'woocommerce' ) ) {
			if ( is_shop() ) {
				$tt_post_id = get_option( 'woocommerce_shop_page_id' );
			}
			if ( is_account_page() ) {
				$tt_post_id = get_option( 'woocommerce_myaccount_page_id' );
			}
			if ( is_checkout() ) {
				$tt_post_id = get_option( 'woocommerce_checkout_page_id' );
			}
			if ( is_cart() ) {
				$tt_post_id = get_option( 'woocommerce_cart_page_id' );
			}
		}

		return $tt_post_id;

	}
}

/*-----------------------------------------------------------------------------------*/
/* Load a file from child theme first if exists.                            */
/*-----------------------------------------------------------------------------------*/

if( !function_exists('ranbron_load_proper_file') ) {
	function ranbron_load_proper_file( $filename = '', $require_once = true ) {

		// Search for file in stylesheet directory
		if ( file_exists( STYLESHEETPATH . $filename ) ) {
			load_template( STYLESHEETPATH . $filename, $require_once );
		} // Search for template in theme directory
		elseif ( file_exists( TEMPLATEPATH . $filename ) ) {
			load_template( TEMPLATEPATH . $filename, $require_once );
		} // Search for template in plugin directory
		else {
		}

	}
}

/*-----------------------------------------------------------------------------------*/
/* Header classes. */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_fw_hdr_class' ) ) {
function ranbron_fw_hdr_class () {
	global $wp_query; $tt_post_id = $single_data2 = $hdr_type ='';
	$class = 'no-Olap inner-header';
	$single_hdr_type = '';

	// grab value from themeoptions
	$hdr_type = ranbron_fw_get_option( 'header_layout', 'default' );

	// grab values from page meta
	if ( !is_404() && !is_search() ) {
		if ( ! empty( $wp_query->post->ID ) ) {
			$tt_post_id = $wp_query->post->ID;
		}
	}
	if( isset($tt_post_id) ) $single_data2 = get_post_meta( $tt_post_id, '_tt_meta_page_opt', true );
	if( is_array($single_data2) ) {
		if ( isset( $single_data2['_single_hdr_type'] ) ) $single_hdr_type = $single_data2['_single_hdr_type'];
	}

	if( $single_hdr_type == 'default' || $single_hdr_type == 'naked' ) $hdr_type = $single_hdr_type;


	if ( ($hdr_type === 'naked') && is_page() ) $class = ' absolute '; // overlapping only on pages.

	return $class;

} // End ranbron_fw_hdr_class()
}

/*-----------------------------------------------------------------------------------*/
/* Truncate */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_tt_truncate' ) ) {
	function ranbron_tt_truncate($text, $limit, $sep='...') {
		if (str_word_count($text, 0) > $limit) {
			$words = str_word_count($text, 2);
			$pos = array_keys($words);
			$text = strip_tags( $text );
			$text = substr($text, 0, $pos[$limit]) . $sep;
		}
		return $text;
	}
}


/*-----------------------------------------------------------------------------------*/
/* Fixing the font size for the tag cloud widget.                                    */
/*-----------------------------------------------------------------------------------*/
add_filter( 'widget_tag_cloud_args', 'ranbron_tt_tag_cloud_args' );
if (!function_exists( 'ranbron_tt_tag_cloud_args')) {
	function ranbron_tt_tag_cloud_args($args) {
	$args['number'] = 10; //adding a 0 will display all tags
	$args['largest'] = 15; //largest tag
	$args['smallest'] = 15; //smallest tag
	$args['unit'] = 'px'; //tag font unit
	$args['format'] = 'list'; //ul with a class of wp-tag-cloud
	return $args;
	}
}

/*-----------------------------------------------------------------------------------*/
/* ranbron_tt_prev_post function */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_tt_prev_post' ) ) {
	function ranbron_tt_prev_post() {
		$output    = '';
		$prev_post = get_adjacent_post( true, '', true );
		if ( is_a( $prev_post, 'WP_Post' ) ) {
			$output = '<div class="fl button3"><a class="tt_prev_post " title="'. get_the_title( $prev_post->ID ) .'" href="' . get_permalink( $prev_post->ID ) . '"><i class="fa fa-long-arrow-left"></i>' . esc_html__( 'Previous Post', 'ranbron' ) . '</a></div>';
		}

		return $output;
	} // End ranbron_tt_prev_post()
}
/*-----------------------------------------------------------------------------------*/
/* ranbron_tt_next_post function */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_tt_next_post' ) ) {
	function ranbron_tt_next_post() {
		$output    = '';
		$prev_post = get_adjacent_post( true, '', false );
		if ( is_a( $prev_post, 'WP_Post' ) ) {
			$output = '<div class="fr button3"><a class="tt_next_post" title="'. get_the_title( $prev_post->ID ) .'" href="' . get_permalink( $prev_post->ID ) . '">' . esc_html__( 'Next Post', 'ranbron' ) . '<i class="fa fa-long-arrow-right"></i></a></div>';
		}

		return $output;
	} // End ranbron_tt_next_post()
}

/*-----------------------------------------------------------------------------------*/
/* ranbron_tt_post_title function */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_tt_post_title' ) ) {
function ranbron_tt_post_title ( ) {

	$hide_title_display = $tt_page_title = $titlesettings = ''; $id = get_the_ID();
	$hide_title_display = get_post_meta( $id, '_tt_meta_page_opt', true );
	if( isset($hide_title_display['_hide_title_display'])) $titlesettings = $hide_title_display['_hide_title_display'];

	ob_start(); ?>
		<header class="post-header lc_tt_title">
			<ul>
				<li><?php the_time( 'M j, Y' ); ?></li>
				<li><?php if(!comments_open($id)) echo 'Comments Off'; else comments_popup_link( esc_html__( 'Zero comments', 'ranbron' ), esc_html__( '1 Comment', 'ranbron' ), esc_html__( '% Comments', 'ranbron' ) ); ?></li>
			</ul>
			<h1><?php if( strlen( get_the_title()) > 1 ) { ?> <a href="<?php the_permalink(); ?>" title="<?php esc_attr_e( 'Continue Reading &rarr;', 'ranbron' ); ?>"><?php the_title(); ?></a> <?php } ?></h1>
		</header>
		<?php

	$tt_post_title = ob_get_clean();
	if( is_singular() ){
		if( empty($titlesettings) || $titlesettings == '0' ) {
			echo esc_attr($tt_post_title);
		} // display title if not being hidden in single post.
	}
	else { echo esc_attr($tt_post_title); }
	} // End ranbron_tt_post_title()
}

/*-----------------------------------------------------------------------------------*/
/* ranbron_tt_page_title function */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_tt_page_title' ) ) {
function ranbron_tt_page_title ( ) {

	$hide_title_display = $tt_page_title = $titlesettings = '';
	$hide_title_display = get_post_meta( get_the_ID(), '_tt_meta_page_opt', true );
	if( isset($hide_title_display['_hide_title_display'])) $titlesettings = $hide_title_display['_hide_title_display'];

	ob_start();
	if ( empty($titlesettings) || $titlesettings == '0' ) { ?>
		<header class="post-header">
			<h1><?php if( strlen( get_the_title()) > 1 ) the_title(); ?></h1>
		</header>
		<?php
	} // display title if not being hidden in single page/post.

	$tt_page_title = ob_get_clean();
	echo esc_attr($tt_page_title);

	} // End ranbron_tt_page_title()
}


/*-----------------------------------------------------------------------------------*/
/* Function to retrieve tags. */
/*-----------------------------------------------------------------------------------*/
if( !function_exists( 'ranbron_tt_get_tags' )) {
	function ranbron_tt_get_tags(){
		$tags = get_the_tags();
		$tags_count = 0;
	    $html = '<p class=tagtitle>'. esc_html__('tags ', 'ranbron') .'&nbsp;</p>';
		if( !is_array($tags) ) return;
	    foreach ($tags as $tag){
		    $tags_count ++;
	        $tag_link = get_tag_link($tag->term_id);
						if ( $tags_count > 1 ) {
							$html .= ' '; // tag separator here
						}

	        $html .= "<a href='{$tag_link}' title='{$tag->name} Tag' class='tag {$tag->slug}'>";
	        $html .= "{$tag->name}</a>";
	    }
	    echo '<div class="detail-tags">'. $html .'</div>';
	}
}

/*-----------------------------------------------------------------------------------*/
/* Function to retrieve categories. */
/*-----------------------------------------------------------------------------------*/
/*
 * it can either return single category or all categories separated by comma.
 * by default it returns all category separated by comma but if single category is required, just pass 'single' into the fn.
 *
 */
if (!function_exists('ranbron_tt_get_cats')) {
	function ranbron_tt_get_cats( $return='' ) {
		global $post, $wp_query;
		$output = '';
		$post_type_taxonomies = get_object_taxonomies( get_post_type(), 'objects' );
		foreach ( $post_type_taxonomies as $taxonomy ) {
			if ( $taxonomy->hierarchical == true ) {

				$cats       = get_the_terms( get_the_ID(), $taxonomy->name );
				$cats_count = 0;
				if ( $cats ) {
					foreach ( $cats as $cat ) {
						$cats_count ++;
						if ( $cats_count > 1 && $return == 'single' ) {
							break;
						}
						if ( $cats_count > 1 ) {
							$output .= ', ';
						}
						$output .= '<a class="tt_cats" href="' . get_term_link( $cat, $taxonomy->name ) . '">' . $cat->name . '</a>';
					}
				}
			}
		}
		return $output;
	}
}


/*-----------------------------------------------------------------------------------*/
/* Preloader. */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'ranbron_tt_preloader' ) ) {
function ranbron_tt_preloader () {

	if ( ranbron_fw_get_option( 'enable_preloader', '0' ) == '1') {
		return '
		<div id="loader-wrapper">
		 <div class="tt-loading-center">
		  <div class="tt-loading-center-absolute">
		   <div class="tt-object object_four"></div>
		   <div class="tt-object object_three"></div>
		   <div class="tt-object object_two"></div>
		   <div class="tt-object object_one"></div>
		  </div>
		 </div>
		</div>
		';
	}

} // End ranbron_tt_preloader()
}

/*-----------------------------------------------------------------------------------*/
/* Adding hero images for pages                                                      */
/*-----------------------------------------------------------------------------------*/

if( !function_exists('ranbron_tt_hero_section') ) {
	function ranbron_tt_hero_section() {
	global $ranbron_herobg, $ranbron_heroclr, $tt_temptt_opt, $wp_query;
	$tt_post_id = $single_enable_headline = $single_headline_title = $single_text_align = $single_page_color = $single_page_img = $single_text_apprnce = $single_hero_breadcrumbs = $hide_title_display = $single_display_breadcrumbs = $single_headline_desc = '';
	if ( is_404() || is_search() ) return;
	if( isset($wp_query->post->ID)) $tt_post_id = $wp_query->post->ID;
	if(is_home()) $tt_post_id = get_option( 'page_for_posts' );
	if ( !(shortcode_exists('tt_hero_shortcode')  || shortcode_exists('templatation_hero')) ) return; // nothing left to do!
	if ( class_exists( 'woocommerce' ) ) {
		if ( is_shop() ) {
			$tt_post_id = get_option( 'woocommerce_shop_page_id' );
		}
		if ( is_account_page() ) {
			$tt_post_id = get_option( 'woocommerce_myaccount_page_id' );
		}
		if ( is_checkout() ) {
			$tt_post_id = get_option( 'woocommerce_checkout_page_id' );
		}
		if ( is_cart() ) {
			$tt_post_id = get_option( 'woocommerce_cart_page_id' );
		}
	}
	if( empty($tt_post_id) ) return; // nothing left to do!
	// if the current page template is contact page.
	//$current_page_template = get_post_meta($tt_post_id, '_wp_page_template', true);


	// fetching value from single posts .
	$single_enable_headline = '1';
	$single_data2 = get_post_meta( $tt_post_id, '_tt_meta_page_opt', true );
	if( is_array($single_data2) ) {
		if ( isset( $single_data2['_single_enable_headline'] ) ) $single_enable_headline = $single_data2['_single_enable_headline'];
		if ( isset( $single_data2['_single_headline_title'] ) ) $single_headline_title = esc_attr($single_data2['_single_headline_title']);
		if ( isset( $single_data2['_single_headline_desc'] ) ) $single_headline_desc = esc_textarea($single_data2['_single_headline_desc']);
		if ( isset( $single_data2['_single_text_align'] ) ) $single_text_align = esc_attr($single_data2['_single_text_align']);
		if ( isset( $single_data2['_single_page_img'] ) ) $single_page_img = esc_textarea($single_data2['_single_page_img']);
		if ( isset( $single_data2['_single_page_color'] ) ) $single_page_color = esc_attr($single_data2['_single_page_color']);
		if ( isset( $single_data2['_single_text_apprnce'] ) ) $single_text_apprnce = esc_attr($single_data2['_single_text_apprnce']);
		if ( isset( $single_data2['_single_hero_breadcrumbs'] ) ) $single_hero_breadcrumbs = esc_attr($single_data2['_single_hero_breadcrumbs']);
		if ( isset( $single_data2['_single_display_breadcrumbs'] ) ) $single_display_breadcrumbs = esc_attr($single_data2['_single_display_breadcrumbs']);
	}

	if ( !$single_enable_headline ) return ; // user dont want it!

	// assign global hero bg if not put in meta.
	// grab the hero bg image
	$global_herobg = ranbron_fw_get_option('global_herobg');
	if( !is_array($global_herobg) ) $global_herobg['url'] = '' ;
	//if( empty($global_herobg['url']) ) $global_herobg['url'] = get_template_directory_uri().'/assets/img/defaulthero.jpg' ;

	$single_page_img = $single_page_img ? $single_page_img : $global_herobg['url'];
	$single_page_img = esc_url($single_page_img);

	// if title is not entered , grab the default page title.
	if( '' == $single_headline_title ) $single_headline_title = get_the_title($tt_post_id);

	// if this is single post, show Blog as title. bcuz we dont want double entry for title.
	if( is_singular('post') ) $single_headline_title = esc_html__( 'Blog', 'ranbron' );

	$ranbron_herobg = $single_page_img;
	$ranbron_heroclr = $single_page_color;

	echo do_shortcode('[templatation_hero
	heading="'. $single_headline_title .'"
	image="'. $single_page_img .'"
	color="'. $single_page_color .'"
	content="'. $single_headline_desc .'"
	text_appear="'. $single_text_apprnce .'"
	yoast_bdcmp="'. $single_hero_breadcrumbs .'"
	block_padding_top="-1"
	block_padding_bottom="-1"
	]') ; // all variables in html block are already escaped. we can output directly.
		// Note that setting -1 for block padding top and bottom disables it.
	}
}
add_action( 'tt_before_mainblock', 'ranbron_hero_section_trigger', 1 );

if( !function_exists('ranbron_hero_section_trigger')) {
	function ranbron_hero_section_trigger( ) {

		if ( !(shortcode_exists('tt_hero_shortcode')  || shortcode_exists('templatation_hero')) ) {
			add_action( 'tt_before_mainblock', 'ranbron_hero_bg', 2 );
		}
		else {
			add_action( 'tt_before_mainblock', 'ranbron_tt_hero_section', 2 );
		}

	}
}


// source: https://pippinsplugins.com/retrieve-attachment-id-from-image-url/
if( !function_exists('ranbron_fw_get_image_id')) {
	function ranbron_fw_get_image_id( $image_url ) {
		global $wpdb;
		$attachment = $wpdb->get_col( $wpdb->prepare( "SELECT ID FROM $wpdb->posts WHERE guid='%s';", $image_url ) );
		if( is_array($attachment) && isset($attachment[0]) )
		return $attachment[0];
		else return $image_url;
	}
}

if( !function_exists('ranbron_hero_bg')) {
	function ranbron_hero_bg() {
		$single_headline_title = '';
		// if this is post, show Blog as title. we dont want double entry for title.
		if( is_singular('post') || (is_home() && ! is_front_page()) ) $single_headline_title = esc_html__( 'Blog', 'ranbron' );
        if( is_archive()) $single_headline_title = get_the_archive_title();
			ob_start(); ?>
			<div class="hero-page-title breadcrumb-area banner_area inner-banner">
			<div class="thm-container clearfix">
		<div class="title">
					<?php if('' != $single_headline_title) { ?>
						<h3 class="tt-title"><?php echo wp_kses($single_headline_title, ranbron_tt_allowed_tags()); ?></h3>
						<div class="line"></div>
					<?php } ?>
		</div><!-- /.title pull-left -->
				<?php
				// Breadcrumb
					 if( function_exists('breadcrumb_trail') ){
						 breadcrumb_trail();
					 }
					 elseif ( function_exists('yoast_breadcrumb') ) {
						 yoast_breadcrumb('<div class="yt-breadcrumbs">','</div>');
					 }
				?>
			</div>
			</div>
			<?php $generic_hero = ob_get_clean();
			echo wp_kses_post($generic_hero);
	}
}


/**
 * Add color styling from theme
 */
if(!( function_exists('ranbron_inline_styles1') )) {
	function ranbron_inline_styles1() {

		if( is_home() && ! is_front_page() ) return; /* because hero function handles it */

		// grab the hero bg image
		$global_herobg = ranbron_fw_get_option( 'global_herobg' );
		if ( ! is_array( $global_herobg ) ) {
			$global_herobg['url'] = '';
		}

		$custom_css = "
                .breadcrumb-area{
                        background-image:  url('" . esc_url( $global_herobg['url'] ) . "');
                }";
		wp_add_inline_style( 'ranbron-style', $custom_css );
	}

	add_action( 'wp_enqueue_scripts', 'ranbron_inline_styles1' );
}

/**
 * Add color styling from theme
 */
if(!( function_exists('ranbron_inline_styles2') )) {
	function ranbron_inline_styles2() {

		$single_page_img = $single_page_color = '';

		// grab the hero bg image
		$global_herobg = ranbron_fw_get_option( 'global_herobg' );
		if ( ! is_array( $global_herobg ) ) {
			$global_herobg['url'] = '';
		}
		if( '' != $global_herobg['url'] ) $single_page_img = $global_herobg['url'];

		$tt_id = ranbron_get_the_id();

		if ( empty( $tt_id ) ) {
			return;
		}

		$single_data2 = get_post_meta( $tt_id, '_tt_meta_page_opt', true );
		if ( is_array( $single_data2 ) ) {
			if ( '' != $single_data2['_single_page_img'] ) {
				$single_page_img = esc_textarea( $single_data2['_single_page_img'] );
			}
			if ( '' != $single_data2['_single_page_color'] ) {
				$single_page_color = esc_attr( $single_data2['_single_page_color'] );
			}
		}

		$custom_css = "
                .breadcrumb-area{
                        background-image:  url('" . esc_url( $single_page_img ) . "');
                }";
		if( '' != $single_page_color ) {
			$custom_css .= "
				.overlay-clr{
                        background-color:  " . $single_page_color . ";
                }";
		}
		wp_add_inline_style( 'ranbron-style', $custom_css );

	}

	add_action( 'wp_enqueue_scripts', 'ranbron_inline_styles2' );
}

/**
 * Add retina friendly logo
 */
if(!( function_exists('ranbron_inline_logo_w') )) {
	function ranbron_inline_logo_w() {
		$logo_w = '';

		// grab the hero bg image
		$retina_logo_w = ranbron_fw_get_option( 'retina_logo_w', '50' );

		if ( ! empty( $retina_logo_w ) && is_numeric( $retina_logo_w ) ) {

		$logo_w = "
                .logo.navbar-brand img{
                        width:  " . esc_html( $retina_logo_w ) . '%'.";
                }
				.header .stricky-fixed .navbar-brand > img, .header .navbar-brand > img {
                        width:  " . esc_html( $retina_logo_w ) . '%'.";
				}
				";
		wp_add_inline_style( 'ranbron-style', $logo_w );
		}
	}

	add_action( 'wp_enqueue_scripts', 'ranbron_inline_logo_w' );
}


/*-----------------------------------------------------------------------------------*/
/* Allowed tags                                                                      */
/*-----------------------------------------------------------------------------------*/

if(!( function_exists('ranbron_tt_allowed_tags') )){
	function ranbron_tt_allowed_tags(){
		return array(
		    'img' => array(
		        'src' => array(),
		        'alt' => array(),
		        'class' => array(),
		        'style' => array(),
		    ),
		    'a' => array(
		        'href' => array(),
		        'title' => array(),
		        'class' => array(),
		        'target' => array()
		    ),
		    'br' => array(),
		    'div' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'span' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h1' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h2' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h3' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h4' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h5' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h6' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'style' => array(),
		    'em' => array(),
		    'strong' => array(),
		    'p' => array(
		    	'class' => array(),
		        'style' => array(),
		    ),
		);
	}
}

function ranbron_tt_css_allow($allowed_attr) {

    if (!is_array($allowed_attr)) {
        $allowed_attr = array();
    }

    $allowed_attr[] = 'display';
    $allowed_attr[] = 'background-image';
    $allowed_attr[] = 'url';

    return $allowed_attr;
} add_filter('safe_style_css','ranbron_tt_css_allow');


add_filter( 'wp_nav_menu_items', 'ranbron_add_search_to_nav', 10, 2 );
function ranbron_add_search_to_nav( $items, $args ) {
	$single_data2 = $hdr_type = $hdr_type = $single_hdr_type = '';
	// grab value from themeoptions
	$hdr_type = ranbron_fw_get_option( 'header_layout', 'default' );
	$tt_post_id = ranbron_get_the_id();
	if( isset($tt_post_id) ) $single_data2 = get_post_meta( $tt_post_id, '_tt_meta_page_opt', true );
	if( is_array($single_data2) ) {
		if ( isset( $single_data2['_single_hdr_type'] ) ) $single_hdr_type = $single_data2['_single_hdr_type'];
	}
	if( $single_hdr_type == 'default' || $single_hdr_type == 'header2' || $single_hdr_type == 'header3' || $single_hdr_type == 'header4' || $single_hdr_type == 'header5' ) $hdr_type = $single_hdr_type;
	if( $hdr_type == 'default' || $hdr_type == 'header1' || $hdr_type == 'header2' ) return $items; // we only need to add following in certain menus

	if ( ranbron_fw_get_option('enable_hdr_search', '1') ) {
	$items .= '
                    <li class="nav navbar-nav search-icon-box"><a href="#vb-search" class="popup-with-zoom-anim search-toggle" ><i class="icon icon-Search"></i></a></li>

				';
	}

    return $items;
}


add_filter('tt_project_cpt_args','ranbron_prj_to_cases', 100) ;
function ranbron_prj_to_cases($prj_args) {
	$prj_args['labels']['name']                 = esc_attr__( 'Cases', 'ranbron' );
	$prj_args['labels']['singular_name']        = esc_attr__( 'Case', 'ranbron' );
	$prj_args['labels']['add_new']              = esc_attr__( 'Add Case', 'ranbron' );
	$prj_args['labels']['add_new_item']         = esc_attr__( 'Add Case', 'ranbron' );
	$prj_args['labels']['edit']                 = esc_attr__( 'Edit', 'ranbron' );
	$prj_args['labels']['edit_item']            = esc_attr__( 'Edit Cases', 'ranbron' );
	$prj_args['labels']['new_item']             = esc_attr__( 'New Case', 'ranbron' );
	$prj_args['labels']['view']                 = esc_attr__( 'View Case', 'ranbron' );
	$prj_args['labels']['view_item']            = esc_attr__( 'View Case', 'ranbron' );
	$prj_args['labels']['search_items']         = esc_attr__( 'Search Case', 'ranbron' );
	$prj_args['labels']['not_found']            = esc_attr__( 'No Cases found', 'ranbron' );
	$prj_args['labels']['not_found_in_trash']   = esc_attr__( 'No Cases found in Trash', 'ranbron' );
	$prj_args['labels']['parent']               = esc_attr__( 'Parent Cases', 'ranbron' );

	$prj_args['rewrite']['slug'] = 'cases' ;
	unset($prj_args['exclude_from_search']);
	unset($prj_args['show_in_admin_bar']);
	unset($prj_args['show_in_nav_menus']);
	unset($prj_args['publicly_queryable']);
	unset($prj_args['query_var']);
	$prj_args['show_ui'] = true;
	return $prj_args;
}

add_filter('tt_portfolio_cpt_args','ranbron_port_to_services', 100) ;
function ranbron_port_to_services($prj_args) {
	$prj_args['labels']['name']                 = esc_attr__( 'Services', 'ranbron' );
	$prj_args['labels']['singular_name']        = esc_attr__( 'Service', 'ranbron' );
	$prj_args['labels']['add_new']              = esc_attr__( 'Add Service', 'ranbron' );
	$prj_args['labels']['add_new_item']         = esc_attr__( 'Add Service', 'ranbron' );
	$prj_args['labels']['edit']                 = esc_attr__( 'Edit', 'ranbron' );
	$prj_args['labels']['edit_item']            = esc_attr__( 'Edit Service', 'ranbron' );
	$prj_args['labels']['new_item']             = esc_attr__( 'New Service', 'ranbron' );
	$prj_args['labels']['view']                 = esc_attr__( 'View Service', 'ranbron' );
	$prj_args['labels']['view_item']            = esc_attr__( 'View Service', 'ranbron' );
	$prj_args['labels']['search_items']         = esc_attr__( 'Search Service', 'ranbron' );
	$prj_args['labels']['not_found']            = esc_attr__( 'No Services found', 'ranbron' );
	$prj_args['labels']['not_found_in_trash']   = esc_attr__( 'No Services found in Trash', 'ranbron' );
	$prj_args['labels']['parent']               = esc_attr__( 'Parent Services', 'ranbron' );

	$prj_args['rewrite']['slug'] = 'service' ;
	unset($prj_args['exclude_from_search']);
	unset($prj_args['show_in_admin_bar']);
	unset($prj_args['show_in_nav_menus']);
	unset($prj_args['publicly_queryable']);
	unset($prj_args['query_var']);
	$prj_args['show_ui'] = true;
	$prj_args['supports'] = array( 'title', 'editor', 'thumbnail', 'excerpt' );
	return $prj_args;
}



/*-----------------------------------------------------------------------------------*/
/* END */
/*-----------------------------------------------------------------------------------*/

