<?php
/**
 * The template for displaying comments.
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package ranbron
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
    return;
}
?>

<div id="comments" class="comments-area s_comment_list">

    <?php // You can start editing here -- including this comment! ?>

    <?php if ( have_comments() ) : ?>
        <div class="comments-title title">
        <h3>
            <?php
                printf( _nx( 'One thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', get_comments_number(), 'comments title', 'ranbron' ),
                    number_format_i18n( get_comments_number() ), '<span>' . get_the_title() . '</span>' );
            ?>
        </h3>
        </div>

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
        <nav id="comment-nav-above" class="comment-navigation">
            <h1 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'ranbron' ); ?></h1>
<?php if ( get_previous_comments_link() ) { ?>
            <div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'ranbron' ) ); ?></div>
 <?php }
                    if ( get_next_comments_link() ) { ?>
            <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'ranbron' ) ); ?></div>
 <?php } ?>
        </nav><!-- #comment-nav-above -->
        <?php endif; // check for comment navigation ?>

        <ol class="comment-list">
            <?php
                wp_list_comments( array(
                    'callback'      => 'ranbron_fw_cust_cmnt',
                    'short_ping'    => true,
                    'avatar_size'   => 70,
                    'type'          => 'all',
                ) );
            ?>
        </ol><!-- .comment-list -->

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
        <nav id="comment-nav-below" class="comment-navigation">
            <h1 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'ranbron' ); ?></h1>
<?php if ( get_previous_comments_link() ) { ?>
            <div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'ranbron' ) ); ?></div>
<?php }
                    if ( get_next_comments_link() ) { ?>
            <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'ranbron' ) ); ?></div>
 <?php } ?>
        </nav><!-- #comment-nav-below -->
        <?php endif; // check for comment navigation ?>

    <?php endif; // have_comments() ?>

    <?php
        // If comments are closed and there are comments, let's leave a little note, shall we?
        if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
    ?>
        <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'ranbron' ); ?></p>
    <?php endif; ?>

 <?php
        /* Loads the comment-form.php template
        /* get_template_part('comment-form');
        */
    ?>

    <?php comment_form(); ?>

</div><!-- #comments -->
