<?php if( function_exists('ranbron_topnav_content')) echo ranbron_topnav_content($class='top-bar-home-three'); ?>

<div class="header-top-home-three">
    <div class="thm-container clearfix">
        <div class="logo pull-left">
            <!-- Logo -->
            <?php if(ranbron_fw_get_option('use_logo', '1')) {
				echo ranbron_fw_logo($type='2');
            } else { ?>
            <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
			<?php } ?>
        </div><!-- /.logo pull-left -->
<!-- Mobile Navigation Toggler -->
<div class="mobile-nav-toggler style-two"><span class="icon icon fa fa-bars"></span></div>
        <div class="header-top-contact pull-right">
            <div class="single-header-top-content">
	            <div class="icon-box">
                    <i class="icon icon-Pointer"></i>
                </div>
                <div class="text-box">
                    <h4><?php echo ranbron_fw_get_option('hdr_addr1', '13005 Greenville Avenue'); ?></h4>
                    <p><?php echo ranbron_fw_get_option('hdr_addr2', 'California, TX 70240'); ?></p>
                </div><!-- /.text-box -->
            </div><!-- /.single-header-top-content -->
            <div class="single-header-top-content">
                <div class="icon-box">
                    <i class="icon icon-Phone2"></i>
                </div><!-- /.icon-box -->
                <div class="text-box">
                    <h4><?php echo ranbron_fw_get_option('contact_number', '(1800) 456 7890'); ?> </h4>
                    <p><?php echo ranbron_fw_get_option('hdr_ph_label', 'Toll Free'); ?></p>
                </div><!-- /.text-box -->
            </div><!-- /.single-header-top-content -->
            <div class="single-header-top-content">
                <div class="icon-box">
                    <i class="icon icon-Timer"></i>
                </div><!-- /.icon-box -->
                <div class="text-box">
                    <h4><?php echo ranbron_fw_get_option('hdr_opentiming1', 'Mon - Sat 9.00 - 19.00'); ?></h4>
                    <p><?php echo ranbron_fw_get_option('hdr_opentiming2', 'Sunday Closed'); ?></p>
                </div><!-- /.text-box -->
            </div><!-- /.single-header-top-content -->
        </div><!-- /.header-top-contact -->
    </div><!-- /.thm-container -->
</div><!-- /.header-top -->

<header class="header home-page-three">
    <nav class="navbar navbar-default header-navigation stricky">
        <div class="thm-container clearfix">
            <!-- Brand and toggle get grouped for better mobile display -->
            <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target=".main-navigation" aria-expanded="false">
                <span class="sr-only"><?php esc_html_e( 'Toggle navigation', 'ranbron' ); ?></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
            </div>
            <!-- Collect the nav links, forms, and other content for toggling -->
            <div class="collapse navbar-collapse main-navigation" id="main-nav-bar">
	            <!-- The WordPress Menu goes here -->
	            <?php wp_nav_menu(
	                    array(
	                        'depth'             => 3,
	                        'theme_location'    => 'primary-menu',
	                        'container_class'   => 'primary-menu-container',
	                        'menu_class'        => 'nav navbar-nav navigation-box',
	                        'fallback_cb'       => '',
	                        'menu_id'           => 'main-menu',
							'walker'          => new Ranbron_WP_Bootstrap_Navwalker(),
	                    )
	            ); ?>

            </div><!-- /.navbar-collapse -->
	        <?php if( '1' == ranbron_fw_get_option('enable_hdr_button', '1')) { ?>
            <div class="right-side-box">
                <a href="<?php echo ranbron_fw_get_option('hdr_btn_link', '#'); ?>" class="qoute-btn">
	                <?php echo ranbron_fw_get_option('hdr_btn_text', 'Get a Quote'); ?>
                </a>
            </div><!-- /.right-side-box -->
			<?php } ?>
        </div><!-- /.container -->
    </nav>
	<?php get_template_part( 'templates/mobilemenu' ); ?>
</header><!-- /.header -->