<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/*-----------------------------------------------------------------------------------*/
/* This file hooks the redux options panel. While Redux powered by TT FW plugin.
/*-----------------------------------------------------------------------------------*/


add_filter('redux/options/tt_temptt_opt/sections', 'ranbron_tt_redux_options');

if ( ! function_exists( 'ranbron_tt_redux_options' ) ) {
    function ranbron_tt_redux_options( $sections ) {

	//reset themeoptions array
    $sections = array();

	$shortname = 'tt';

    /*
     *
     * ---> START SECTIONS
     *
     */

/*-----------------------------------------------------------------------------------*/
/* General Settings                                                                  */
/*-----------------------------------------------------------------------------------*/

    $sections[] = array(
        'title'  => esc_html__( 'General Settings', 'ranbron' ),
        'id'     => 'general',
        'desc'   => esc_html__( 'General Settings.', 'ranbron' ),
        //'icon'   => 'el el-home ',
        'customizer_width' => '400px',
    );
	// quick start.
    $sections[] = array(
        'title'            => esc_html__( 'Quick Start', 'ranbron' ),
        'id'               => 'general-quickstart',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(

            array(
                'id' => $shortname . '_welcome_info',
                'type'   => 'info',
                'notice' => false,
                'style'  => 'info',
                'desc'   =>  sprintf( esc_html__( 'Thanks for purchasing and installing this theme. From here you can customize almost everything in the theme. If you need help, please %1$s we will be more than happy to help. ', 'ranbron' ), '<a href="http://templatation.com/">' . esc_html__( 'contact support', 'ranbron' ) . '</a>' ),
            ),


            array(
                'id' => $shortname . '_use_logo',
                'type'     => 'switch',
                'default'  => true,
                'title'    => esc_html__( 'Use Logo', 'ranbron' ),
                'desc'     => esc_html__( 'If disabled, the default site title appears instead of logo. You can edit that title in Settings -> General.', 'ranbron' ),
            ),
            array(
                'id' => $shortname . '_logo',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'Upload Main Logo', 'ranbron' ),
                'readonly'    => false,
                'subtitle'     => esc_html__( 'Upload a logo for your theme, or specify an image URL directly. For retina friendliness you can upload 2x logo and set desired dimension in retina ready graphics option below.', 'ranbron' ),
                'desc' => esc_html__( 'If no logo uploaded, default logo appears. Default logo size is 80x27 px.', 'ranbron' ),
                 'required' => array( $shortname . '_use_logo', '=', true )

            ),
            array(
                'id' => $shortname . '_logo2',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'Upload Secondary Logo', 'ranbron' ),
                'readonly'    => false,
                'subtitle'     => esc_html__( 'For sticky menu', 'ranbron' ),
                'desc' => esc_html__( 'The sticky menu background is white, so if you have light version of logo, you might want to upload a secondary dark version logo for sticky menu. Note: This logo only appears in sticky menu.', 'ranbron' ),
                 'required' => array( $shortname . '_use_logo', '=', true )

            ),
                array(
                    'id' => $shortname . '_retina_logo_w',
                    'type' => 'text',
                    'title' => esc_html__('Retina Logo resize.', 'ranbron'),
                    'subtitle' => esc_html__('If logo is too small, try putting 100 here.', 'ranbron'),
                    'desc' => esc_html__('If you want high resolution logo,  please upload double size logo and then enter 50 here. Then the logo will be resized to its 50% width. Please enter number only. eg : 50', 'ranbron'),
                    'default' => '50',
                ),
           array(
                'id' => $shortname . '_enable_preloader',
                'type'     => 'switch',
                'title' => esc_html__( 'Enable Preloader', 'ranbron' ),
                'subtitle' => esc_html__( 'If enabled, website shows a preloader icon before the page loads.', 'ranbron' ),
                'default'  => true
           ),
           array(
                'id' => $shortname . '_enable_hdr_search',
                'type'     => 'switch',
                'title' => esc_html__( 'Enable Header Search', 'ranbron' ),
                'subtitle' => esc_html__( 'If enabled, search icon appears after the top menu bar. (Applicable only on few header types.)', 'ranbron' ),
                'default'  => true
           ),
         ),
);


$query['autofocus[section]'] = 'custom_css';
 $panel_link = add_query_arg( $query, esc_url(admin_url( 'customize.php' )) );
    $sections[] = array(
        'title'            => esc_html__( 'Custom CSS', 'ranbron' ),
        'id'               => 'display-options',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
            array(
                'id' => $shortname . '_cust_css2',
                'type'   => 'info',
                'notice' => false,
                'style'  => 'info',
                'title' => esc_html__( 'Custom Css', 'ranbron' ),
                'desc'   => sprintf( esc_html__( 'Now as WordPress customiser already has the feature to add Additional Css, to have things consolidated, please add css to Appearance -> Customise -> Additional CSS or go there by %s.', 'ranbron' ), '<a href="' . esc_url( $panel_link ).'">'.esc_html__( 'Clicking Here', 'ranbron' ).'</a>' ),
            ),
        )
    );


/*-----------------------------------------------------------------------------------*/
/* Style Settings                                                                  */
/*-----------------------------------------------------------------------------------*/

    $sections[] = array(
        'title'            => esc_html__( 'Styling', 'ranbron' ),
        'id'               => 'body-options',
        'customizer_width' => '450px',
        'icon'   => 'el el-icon-brush',
        'fields'           => array(

            array(
                'id' => $shortname . '_live_cust_info',
                'type'   => 'info',
                'notice' => false,
                'style'  => 'info',
                'title' => esc_html__( 'Live Customizer', 'ranbron' ),
                'desc'   =>  sprintf( esc_html__( 'Please note that theme main colors settings can also be done using Live customizer, you can see live preview if you use live customizer. %1$s.', 'ranbron' ), '<a href="' . esc_url( home_url('/') ) . 'wp-admin/customize.php">' . esc_html__( 'Go to Live Customer (Appearance-Customize) by clicking here', 'ranbron' ) . '</a>' ),
            ),
           array(
                'id' => $shortname . '_main_acnt_clr',
                'type'     => 'color',
                'title'    => esc_html__( 'Main Accent Color', 'ranbron' ),
                'subtitle' => esc_html__( 'Main accent color of the theme. Note: Some color are powered by page builder/images. Contact support if you need help.', 'ranbron' ),
                'desc'     => esc_html__( 'Default: leave blank.', 'ranbron' ),
                'default'  => ''
           ),
            array(
                'id' => $shortname . '_extreme_ft_bg',
                'type'     => 'background',
                'output'   => array( '.footer' ),
                'title'    => esc_html__( 'Footer Background', 'ranbron' ),
                'subtitle' => esc_html__( 'Select background image or color for footer area, where footer widget appears.', 'ranbron' ),
                //'default'   => '#FFFFFF',
            ),
            array(
                'id' => $shortname . '_cssi_info',
                'type'   => 'info',
                'notice' => false,
                'style'  => 'info',
                'title' => esc_html__( 'Further Styling Info', 'ranbron' ),
                'desc'   =>  sprintf( esc_html__( 'If you want to customise the theme further, eg more css edits or custom fonts. Its recommended that you use this plugin https://wordpress.org/plugins/easy-google-fonts/ for using other Google fonts and %1$s for deeper css customisation using point and click interface.', 'ranbron' ), '<a href="https://wordpress.org/plugins/so-css/">' . esc_html__( 'Site Origin CSS plugin', 'ranbron' ) . '</a>' ),
            ),
        )
        );
/*-----------------------------------------------------------------------------------*/
/* Layout Settings                                                                  */
/*-----------------------------------------------------------------------------------*/

    $sections[] = array(
        'title' => esc_html__( 'Layout (Header/Menu)', 'ranbron' ),
        'id'               => 'layout-options',
        'desc'   => esc_html__( 'Layout Settings for Sidebar and Header.', 'ranbron' ),
        'icon'   => 'el el-photo ',
        'customizer_width' => '400px',
        'fields'           => array(
            array(
                'id' => $shortname . '_header_layout',
                'type'     => 'image_select',
                'title' => esc_html__( 'Header/Menu Layout', 'ranbron' ),
                'subtitle' => esc_html__( 'Select header layout. ', 'ranbron' ),
                'desc' => esc_html__( 'Note: This setting can be setup on per page basis too from page settings. For example, you can have Default header globally but can set Center header on landing page for a new room launch.', 'ranbron' ),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    'default' => array(
                        'alt' => 'Default Header',
                        'img' => RANBRON_THEME_DIRURI. 'inc/images/hdr1.png',
                        'title' => 'Default Header.'
                    ),
                    'header2' => array(
                        'alt' => 'Header 2',
                        'img' => RANBRON_THEME_DIRURI. 'inc/images/hdr2.png',
                        'title' => 'Header 2.'
                    ),
                    'header3' => array(
                        'alt' => 'Header 3',
                        'img' => RANBRON_THEME_DIRURI. 'inc/images/hdr3.png',
                        'title' => 'Header 3.'
                    ),
                    'header4' => array(
                        'alt' => 'Header 4',
                        'img' => RANBRON_THEME_DIRURI. 'inc/images/hdr4.png',
                        'title' => 'Header 4.'
                    ),
                    'header5' => array(
                        'alt' => 'Header 5',
                        'img' => RANBRON_THEME_DIRURI. 'inc/images/hdr5.png',
                        'title' => 'Header 5.'
                    ),
                ),
                'default'  => 'default'
            ),

			array(
					'id'       => $shortname . '_hdr_addr1',
					'type'     => 'text',
					'title'    => esc_html__( 'Header address 1. Not applicable on header 1 and header 2.', 'ranbron' ),
			),

			array(
					'id'       => $shortname . '_hdr_addr2',
					'type'     => 'text',
					'title'    => esc_html__( 'Header address 2. Not applicable on header 1 and header 2.', 'ranbron' ),
			),
			array(
					'id'       => $shortname . '_hdr_ph_label',
					'type'     => 'text',
					'title'    => esc_html__( 'Label for Phone number. Note that phone number can be put in Contact tab below. Not applicable on header 1 and header 2.', 'ranbron' ),
			),
			array(
					'id'       => $shortname . '_hdr_opentiming1',
					'type'     => 'text',
					'title'    => esc_html__( 'Header Office timing line 1.', 'ranbron' ),
			),
			array(
					'id'       => $shortname . '_hdr_opentiming2',
					'type'     => 'text',
					'title'    => esc_html__( 'Header Office timing line 2.', 'ranbron' ),
			),
            array(
                'id' => $shortname . '_enable_hdr_button',
                'type'     => 'switch',
                'title' => esc_html__( 'Enable Button in header. Not applicable on header 1 and header 2.', 'ranbron' ),
                'default'  => false
            ),
            array(
                'id' => $shortname . '_hdr_btn_text',
                'type'     => 'text',
                'title' => esc_html__( 'Anchor text for button. Not applicable on header 1 and header 2.', 'ranbron' ),
                'default'  => 'Get a Quote',
                'required' => array( $shortname . '_enable_hdr_button', '=', true )
            ),
            array(
                'id' => $shortname . '_hdr_btn_link',
                'type'     => 'text',
                'title' => esc_html__( 'Link for the button. Not applicable on header 1 and header 2.', 'ranbron' ),
                'default'  => '#',
                'required' => array( $shortname . '_enable_hdr_button', '=', true )
            ),
            array(
                'id' => $shortname . '_js_topbar_notice',
                'type'   => 'info',
                'notice' => false,
                'style'  => 'info',
                'title' => esc_html__( 'Toppest Bar Settings', 'ranbron' ),
                'desc'   => esc_html__( 'Below settings are for the top most navigation bar which is optional. It adds some usual user interface items. There is limited space on this bar , so be careful in choosing what part you really need. You can try it out and disable things later if bar goes out of space. Note: Applicable on header 2 and 3.', 'ranbron' )
            ),
            array(
                'id' => $shortname . '_enable_topbar',
                'type'     => 'switch',
                'title' => esc_html__( 'Enable Top Nav Bar. Applicable on header 2 and 3.', 'ranbron' ),
                'subtitle' => esc_html__( 'Enable/Disable the Top most nav bar globally. Applicable on header 2 and 3.', 'ranbron' ),
                'default'  => true,
            ),
            array(
    			'id' => $shortname . '_top_nav_left_layout',
                'type'     => 'sorter',
                'title'    => 'Top nav left content',
                'subtitle' => 'You can place content as you want, on left side of the top nav. Sort them, or disable by moving them back to Available column. Note that here you can only enable/disable/sort them, their actual content can be controlled from the options below. Note: Email/phone to be entered in Social/contact setting below. ',
                'compiler' => 'true',
                'options'  => array(
                    'enabled'  => array(
                        'email'     => 'Email',
                        'phone'   => 'Phone',
                    ),
                    'disabled' => array(
                        'teaser_text'   => 'Text',
                        //'wpml_lang'   => 'WPML Languages',
                        'social'   => 'Social Icons',
                        'spacer'   => 'Blank Space',
                        'spacer2'   => 'Blank Space 2',
                    ),
                ),
                'required' => array( $shortname . '_enable_topbar', '=', true )
            ),
            array(
    			'id' => $shortname . '_top_nav_right_layout',
                'type'     => 'sorter',
                'title'    => 'Top nav right content',
                'subtitle' => 'You can place content as you want, on right side of the top nav. Sort them, or disable by moving them back to Available column. Note that here you can only enable/disable/sort them, their actual content can be controlled from the options below. Note: Email/phone to be entered in Social/contact setting below. ',
                'compiler' => 'true',
                'options'  => array(
                    'enabled'  => array(
                        'social'   => 'Social Icons',
                    ),
                    'disabled' => array(
                        'email'     => 'Email',
                        'phone'   => 'Phone',
                        'teaser_text'   => 'Text',
                        //'wpml_lang'   => 'WPML Languages',
                        'spacer'   => 'Blank Space',
                        'spacer2'   => 'Blank Space 2',
                    ),
                ),
                'required' => array( $shortname . '_enable_topbar', '=', true )
            ),

           array(
                'id' => $shortname . '_ttext_text',
                'type'     => 'text',
                'title' => esc_html__( 'Teaser Text', 'ranbron' ),
                'subtitle' => esc_html__( 'Teaser text is short sentence that you want to highlight. eg : Our helpline number : xyz. This text appears on left most side of top bar.', 'ranbron' ),
                'required' => array( $shortname . '_enable_topbar', '=', true )
           ),
            array(
                'id'       => $shortname . '_global_herobg',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'Hero area Global background', 'ranbron' ),
                'readonly' => false,
                'subtitle' => esc_html__( 'In this theme, heading area of page shows Hero section, which has an image in background. You can set that background image on per page basis. But choose one global image here which applies by default.', 'ranbron' ),
            ),
        )
    );

/*-----------------------------------------------------------------------------------*/
/* Footer Settings                                                                  */
/*-----------------------------------------------------------------------------------*/

    $sections[] = array(
        'title' => esc_html__( 'Footer Customization', 'ranbron' ),
        'id'               => 'footer-settings1',
        'customizer_width' => '450px',
        'fields'           => array(


           array(
                'id' => $shortname . '_extreme_footer_notice',
                'type'   => 'info',
                'notice' => false,
                'style'  => 'info',
                'title' => esc_html__( 'Footer area customization', 'ranbron' ),
                'desc'   => esc_html__( 'Customize footer area here. Note: Background colors for footer areas can be changed from Styling tab.', 'ranbron' )
           ),

           array(
                'id' => $shortname . '_footer_sidebars',
                'type'     => 'image_select',
                'title' => esc_html__( 'Footer Widget Areas', 'ranbron' ),
                'subtitle' => esc_html__( 'Select how many footer widget areas you want to display.', 'ranbron' ),
                'desc'     => esc_html__( 'Select default sidebar position for the website. Note: The last option is theme specific layout(if applicable).)', 'ranbron' ),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '0' => array(
                        'img' => RANBRON_THEME_DIRURI .'inc/images/footer-widgets-0.png',
                    ),
                    '1' => array(
                        'img' => RANBRON_THEME_DIRURI .'inc/images/footer-widgets-1.png',
                    ),
                    '2' => array(
                        'img' => RANBRON_THEME_DIRURI .'inc/images/footer-widgets-2.png',
                    ),
                    '3' => array(
                        'img' => RANBRON_THEME_DIRURI .'inc/images/footer-widgets-3.png',
                    ),
                    '4' => array(
                        'img' => RANBRON_THEME_DIRURI .'inc/images/footer-widgets-4.png',
                    ),
                    '5' => array(
                        'img' => RANBRON_THEME_DIRURI .'inc/images/footer-widgets-4.png',
                    ),
                ),
                'default'  => '5'
           ),

           array(
                'id' => $shortname . '_footer_left',
                'type'     => 'switch',
                'title' => esc_html__( 'Enable Custom Footer (Left)', 'ranbron' ),
                'subtitle' => esc_html__( 'Activate to add the custom text below to the theme footer.', 'ranbron' ),
                'desc'   => esc_html__( 'If turned off, default text will appear.', 'ranbron' ),
                'default'  => false,
            ),

           array(
                'id' => $shortname . '_footer_left_text',
                'type'     => 'textarea',
                'title' => esc_html__( 'Custom Text (Left)', 'ranbron' ),
                'subtitle' => esc_html__( 'Custom HTML and Text that will appear in the upper footer of your theme.', 'ranbron' ),
                'validate' => 'html', //see http://codex.wordpress.org/Function_Reference/wp_kses_post
                'default'  => '',
           ),

        )
    );

/*-----------------------------------------------------------------------------------*/
/* Social Settings                                                                  */
/*-----------------------------------------------------------------------------------*/

    $sections[] = array(
        'title' => esc_html__( 'Social / Contact Settings', 'ranbron' ),
        'id'               => 'connect-settings',
        'customizer_width' => '450px',
        'fields'           => array(

            array(
                'id' => $shortname . '_contact_number',
                'type'     => 'text',
                'title' => esc_html__( 'Telephone', 'ranbron' ),
                'subtitle' => esc_html__( 'Enter your telephone number', 'ranbron' ),
                'default'  => '000-111-222',
            ),
            array(
                'id' => $shortname.'_contactform_email',
                'type'     => 'text',
                'title' => esc_html__( 'Contact Form E-Mail', 'ranbron' ),
                'subtitle' => esc_html__( "Enter your E-mail address to use on the 'Contact Form' page Template.", 'ranbron' ),
                'default'  => 'dummy@dummy.com',
            ),
            array(
                'id' => $shortname . '_connect_rss',
                'type'     => 'switch',
                'title' => esc_html__( 'Enable RSS', 'ranbron' ),
                'subtitle' => esc_html__( 'Enable the subscribe and RSS icon.', 'ranbron' ),
                 'default'  => true
            ),
            array(
                'id' => $shortname . '_connect_twitter',
                'type'     => 'text',
                'title' => esc_html__( 'Twitter URL', 'ranbron' ),
                'subtitle' => sprintf( esc_html__( 'Enter your %1$s URL e.g. http://www.twitter.com/templatation', 'ranbron' ), '<a href="http://www.twitter.com/">'.esc_html__( 'Twitter', 'ranbron' ).'</a>' ),
                'default'  => '#',
            ),
            array(
                'id' => $shortname . '_connect_facebook',
                'type'     => 'text',
                'title' => esc_html__( 'Facebook URL', 'ranbron' ),
                'subtitle' => sprintf( esc_html__( 'Enter your %1$s URL e.g. http://www.facebook.com/templatation', 'ranbron' ), '<a href="http://www.facebook.com/">'.esc_html__( 'Facebook', 'ranbron' ).'</a>' ),
                'default'  => '#',
            ),
            array(
                'id' => $shortname . '_connect_youtube',
                'type'     => 'text',
                'title' => esc_html__( 'YouTube URL', 'ranbron' ),
                'subtitle' => sprintf( esc_html__( 'Enter your %1$s URL e.g. http://www.youtube.com/templatation', 'ranbron' ), '<a href="http://www.youtube.com/">'.esc_html__( 'YouTube', 'ranbron' ).'</a>' ),
                'default'  => '',
            ),
            array(
                'id' => $shortname . '_connect_flickr',
                'type'     => 'text',
                'title' => esc_html__( 'Flickr URL', 'ranbron' ),
                'subtitle' => sprintf( esc_html__( 'Enter your %1$s URL e.g. http://www.flickr.com/templatation', 'ranbron' ), '<a href="http://www.flickr.com/">'.esc_html__( 'Flickr', 'ranbron' ).'</a>' ),
                'default'  => '',
            ),
            array(
                'id' => $shortname . '_connect_linkedin',
                'type'     => 'text',
                'title' => esc_html__( 'LinkedIn URL', 'ranbron' ),
                'subtitle' => sprintf( esc_html__( 'Enter your %1$s URL e.g. http://www.linkedin.com/in/templatation', 'ranbron' ), '<a href="http://www.www.linkedin.com.com/">'.esc_html__( 'LinkedIn', 'ranbron' ).'</a>' ),
                'default'  => '',
            ),
            array(
                'id' => $shortname . '_connect_pinterest',
                'type'     => 'text',
                'title' => esc_html__( 'Pinterest URL', 'ranbron' ),
                'subtitle' => sprintf( esc_html__( 'Enter your %1$s URL e.g. http://www.pinterest.com/templatation', 'ranbron' ), '<a href="http://www.pinterest.com/">'.esc_html__( 'Pinterest', 'ranbron' ).'</a>' ),
                'default'  => '#',
            ),
            array(
                'id' => $shortname . '_connect_instagram',
                'type'     => 'text',
                'title' => esc_html__( 'Instagram URL', 'ranbron' ),
                'subtitle' => sprintf( esc_html__( 'Enter your %1$s URL e.g. http://www.instagram.com/templatation', 'ranbron' ), '<a href="http://www.instagram.com/">'.esc_html__( 'Instagram', 'ranbron' ).'</a>' ),
                'default'  => '',
            ),
            array(
                'id' => $shortname . '_connect_googleplus',
                'type'     => 'text',
                'title' => esc_html__( 'Google+ URL', 'ranbron' ),
                'subtitle' => sprintf( esc_html__( 'Enter your %1$s URL e.g. https://plus.google.com/104560124403688998123/', 'ranbron' ), '<a href="http://plus.google.com/">'.esc_html__( 'Google+', 'ranbron' ).'</a>' ),
                'default'  => '',
            ),
            array(
                'id' => $shortname . '_social_custom_start',
                'type'     => 'section',
                'title'    => esc_html__( 'Custom social icons', 'ranbron' ),
                'subtitle' => esc_html__( 'If you want to have any other icon thats not listed above, use this section please. You can add 2 custom icons as of now.',  'ranbron' ),
                'indent'   => true, // Indent all options below until the next 'section' option is set.
            ),
           array(
                'id' => $shortname . '_enable_social_custom',
                'type'     => 'switch',
                'title' => esc_html__( 'Enable custom icon', 'ranbron' ),
                'default'  => false,
            ),
            array(
                'id' => $shortname . '_connect_custom_name',
                'type'     => 'text',
                'title' => esc_html__( 'Social icon name. eg Yelp.', 'ranbron' ),
                'default'  => '',
                'required' => array( $shortname . '_enable_social_custom', '=', true )
            ),
            array(
                'id' => $shortname . '_connect_custom_link',
                'type'     => 'text',
                'title' => esc_html__( 'Social icon link. eg http://www.yelp.com/templatation.', 'ranbron' ),
                'default'  => '',
                'required' => array( $shortname . '_enable_social_custom', '=', true )
            ),
            array(
                'id' => $shortname . '_connect_custom_icon',
                'type'     => 'text',
                'title' => esc_html__( 'Social icon code for Fontawesome. eg fa-yelp. Find all icons here  https://fontawesome.com/icons ', 'ranbron' ),
                'default'  => '',
                'required' => array( $shortname . '_enable_social_custom', '=', true )
            ),
            array(
                'id' => $shortname . '_connect_custom_name2',
                'type'     => 'text',
                'title' => esc_html__( 'Social icon name 2. eg Yelp.', 'ranbron' ),
                'default'  => '',
                'required' => array( $shortname . '_enable_social_custom', '=', true )
            ),
            array(
                'id' => $shortname . '_connect_custom_link2',
                'type'     => 'text',
                'title' => esc_html__( 'Social icon link 2. eg http://www.yelp.com/templatation.', 'ranbron' ),
                'default'  => '',
                'required' => array( $shortname . '_enable_social_custom', '=', true )
            ),
            array(
                'id' => $shortname . '_connect_custom_icon2',
                'type'     => 'text',
                'title' => esc_html__( 'Social icon code for icon 2 Fontawesome. eg fa-yelp. Find all icons here  https://fontawesome.com/icons ', 'ranbron' ),
                'default'  => '',
                'required' => array( $shortname . '_enable_social_custom', '=', true )
            ),
            array(
                'id' => $shortname . '_social_custom_start',
                'type'   => 'section',
                'indent' => false, // Indent all options below until the next 'section' option is set.
            ),
            array(
                'id' => $shortname . '_open_social_newtab',
                'type'     => 'switch',
                'title' => esc_html__( 'Open in New tab', 'ranbron' ),
                'subtitle' => esc_html__( 'If this is turned on, the social icon links open in new tab instead of same window.', 'ranbron' ),
                 'default'  => false
            ),
        )
    );

/*-----------------------------------------------------------------------------------*/
/* Included Plugins / Theme updates                                                  */
/*-----------------------------------------------------------------------------------*/

   $sections[] = array(
        'title' => esc_html__( 'Included Plugins', 'ranbron' ),
        'id'               => 'included-plugins',
        'customizer_width' => '450px',
        'fields'           => array(

            array(
                'id' => $shortname . '_inc_plugins',
                'type'   => 'info',
                'notice' => false,
                'style'  => 'info',
                'title' => esc_html__( 'Included Plugins', 'ranbron' ),
                'desc'   => sprintf( esc_html__( 'The theme requires/recommends some plugin to function properly. Theme also includes some premium plugins with your purchase, to manage plugins, please go to Appearance -> Install plugins. Note: The menu only appears if all required plugins are not activated. So not to worry if you do not find that menu link.', 'ranbron' ), '<a href="' . esc_url( home_url('/') ) . 'wp-admin/themes.php?page=tgmpa-install-plugins">'.esc_html__( 'Click Here', 'ranbron' ).'</a>' ),
            ),
        )
    );

   $sections[] = array(
        'title'  => esc_html__( 'Theme Updates', 'ranbron' ),
        'id'     => 'theme-update',
        'icon'   => 'el el-refresh',
        'customizer_width' => '450px',
        'fields' => array(

            array(
                'id' => $shortname . '_theme_update',
                'type'   => 'info',
                'notice' => false,
                'style'  => 'info',
                'title' => esc_html__( 'Theme Update', 'ranbron' ),
                'desc'   => sprintf( esc_html__( 'The theme is regularly updated with new features and other bug fixes and improvement. You can activate Envato plugin for hassle free theme updates whenever update is available without having to download from Themeforest. Note if you modified any theme files, it will be overwritten with update. Again, make sure to keep regular backups. You can use awesome free plugin named %1$s  to create backups periodically(automatically) without hassles.', 'ranbron' ), '<a href="https://wordpress.org/plugins/updraftplus/">'.esc_html__( 'UpdraftPlus', 'ranbron' ).'</a>' ),
            ),
            array(
                'id' => $shortname . '_theme_update3',
                'type'   => 'info',
                'notice' => false,
                'style'  => 'info',
                'title' => esc_html__( 'Step by Step instruction to setup easy updates.', 'ranbron' ),
                'desc'   => sprintf( esc_html__( 'Please %1s for complete instruction to setup the updater plugin and update easily in future.', 'ranbron' ), '<a href="http://kb.templatation.com/article/35-how-to-update-the-theme">'.esc_html__( 'Click Here', 'ranbron' ).'</a>' ),
            )
        )
    );

/*-----------------------------------------------------------------------------------*/
/* CPT Settings                                                                      */
/*-----------------------------------------------------------------------------------*/
// Display options to manage CPT, as required in this theme.
$ranbron_fw_cpt = '';
$ranbron_fw_cpt = get_option('tt_temptt_components');
if( is_array( $ranbron_fw_cpt )) {
    $sections[] = array(
        'title'            => esc_html__( 'Custom Post Types', 'ranbron' ),
        'id'               => 'theme-cpts',
        'customizer_width' => '450px',
        'fields'           => array(

            array(
                'id'    => $shortname . '_inc_cpt3',
                'type'  => 'info',
                // 'notice' => false,
                'style' => 'info',
                'title' => esc_html__( 'Note : If you are not sure what custom post type means, its ok to skip this section totally !', 'ranbron' ),
            ),
            array(
                'id'     => $shortname . '_inc_cpt',
                'type'   => 'info',
                'notice' => false,
                'style'  => 'info',
                'title'  => esc_html__( 'Custom Post Types', 'ranbron' ),
                'desc'   => esc_html__( 'This theme adds some post types to manage content like testimonials, portfolios etc. You can disable the Post types that you do not need. You can also change the permalink structure for those custom post types here, for example, if you would like portfolio item url to be like http://yoursite.com/portfolio-item/item or http://yoursite.com/my-work/item. If you are not sure what it all means, its ok to skip this section totally.', 'ranbron' ),
            ),
            array(
                'id'    => $shortname . '_inc_cpt1',
                'type'  => 'info',
                // 'notice' => false,
                'style' => 'info',
                'title' => esc_html__( 'Important !', 'ranbron' ),
                'desc'  => esc_html__( 'After changing any settings on this section or its subsections, you need to re-save the Settings > Permalinks page. Otherwise you will get 404 errors.', 'ranbron' ),
            ),
            array(
                'id' => $shortname.'_cpt_with_front',
                'type'     => 'switch',
                'title' => esc_html__( 'Enable With Front', 'ranbron' ),
                'subtitle' => esc_html__( 'Recommended: Off', 'ranbron' ),
                'desc' => esc_html__( 'Prepend the permalink structure with the front base. ( example: if your permalink structure is /blog/, then your links will be: With-Front disabled -> /portfolio-item/, With-Front enabled -> /blog/portfolio-item/ ).', 'ranbron' ),
                'default'  => false
            ),
        )
    );

// Event CPT
if( ! empty( $ranbron_fw_cpt['team_cpt'] ) ) {
    $sections[] = array(
        'title'            => esc_html__( 'Event', 'ranbron' ),
        'id'               => 'event-cpt-setting',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(

            array(
                'id'    => $shortname . '_inc_event',
                'type'  => 'info',
                // 'notice' => false,
                'style' => 'info',
                'title' => esc_html__( 'Important !', 'ranbron' ),
                'desc'  => esc_html__( 'After changing any settings on this section or its subsections, you need to re-save the Settings > Permalinks page. Otherwise you will get 404 errors.', 'ranbron' ),
            ),
            array(
                'id'       => $shortname . '_event_cpt',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Event', 'ranbron' ),
                'subtitle' => esc_html__( 'Enable the Event Custom Post type.', 'ranbron' ),
                'default'  => $ranbron_fw_cpt['team_cpt'] // Hint: will be 1 always.
            ),
            array(
                'id'      => $shortname . '_event_cpt_slug',
                'type'    => 'text',
                'title'   => esc_html__( 'Event Slug', 'ranbron' ),
                'default' => 'event-item',
            ),
            array(
                'id'      => $shortname . '_event_cpt_cat_slug',
                'type'    => 'text',
                'title'   => esc_html__( 'Event Category Slug', 'ranbron' ),
                'default' => 'event-cats',
            ),
            array(
                'id'       => $shortname . '_event_cpt_single',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Single Page', 'ranbron' ),
                'desc' => esc_html__( 'Do you want singular item page for this Custom post type. eg: It makes sense to have a Portfolio item single page with more details about that item. But it makes less sense to have single item page for testimonials. Note: Sometimes theme needs to be re-activated for this change to take effect.', 'ranbron' ),
                'default'  => true
            ),
        )
    );
}
// Client CPT
/*if( ! empty( $ranbron_fw_cpt['client_cpt'] ) ) {
    $sections[] = array(
        'title'            => esc_html__( 'Client', 'ranbron' ),
        'id'               => 'client-cpt-setting',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(

            array(
                'id'    => $shortname . '_inc_client',
                'type'  => 'info',
                // 'notice' => false,
                'style' => 'info',
                'title' => esc_html__( 'Important !', 'ranbron' ),
                'desc'  => esc_html__( 'After changing any settings on this section or its subsections, you need to re-save the Settings > Permalinks page. Otherwise you will get 404 errors.', 'ranbron' ),
            ),
            array(
                'id'       => $shortname . '_client_cpt',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Client', 'ranbron' ),
                'subtitle' => esc_html__( 'Enable the Client Custom Post type.', 'ranbron' ),
                'default'  => $ranbron_fw_cpt['client_cpt'] // Hint: will be 1 always.
            ),
            array(
                'id'      => $shortname . '_client_cpt_slug',
                'type'    => 'text',
                'title'   => esc_html__( 'Client Slug', 'ranbron' ),
                'default' => 'client-item',
            ),
            array(
                'id'      => $shortname . '_client_cpt_cat_slug',
                'type'    => 'text',
                'title'   => esc_html__( 'Client Category Slug', 'ranbron' ),
                'default' => 'client-cats',
            ),
            array(
                'id'       => $shortname . '_client_cpt_single',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Single Page', 'ranbron' ),
                'desc' => esc_html__( 'Do you want singular item page for this Custom post type. eg: It makes sense to have a Portfolio item single page with more details about that item. But it makes less sense to have single item page for testimonials. Note: Sometimes theme needs to be re-activated for this change to take effect.', 'ranbron' ),
                'default'  => false
            ),
        )
    );
}*/
// Project CPT
/*if( ! empty( $ranbron_fw_cpt['project_cpt'] ) ) {
    $sections[] = array(
        'title'            => esc_html__( 'Project', 'ranbron' ),
        'id'               => 'project-cpt-setting',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(

            array(
                'id'    => $shortname . '_inc_project',
                'type'  => 'info',
                // 'notice' => false,
                'style' => 'info',
                'title' => esc_html__( 'Important !', 'ranbron' ),
                'desc'  => esc_html__( 'After changing any settings on this section or its subsections, you need to re-save the Settings > Permalinks page. Otherwise you will get 404 errors.', 'ranbron' ),
            ),
            array(
                'id'       => $shortname . '_project_cpt',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Project', 'ranbron' ),
                'subtitle' => esc_html__( 'Enable the Project Custom Post type.', 'ranbron' ),
                'default'  => $ranbron_fw_cpt['project_cpt'] // Hint: will be 1 always.
            ),
            array(
                'id'      => $shortname . '_project_cpt_slug',
                'type'    => 'text',
                'title'   => esc_html__( 'Project Slug', 'ranbron' ),
                'default' => 'project-item',
            ),
            array(
                'id'      => $shortname . '_project_cpt_cat_slug',
                'type'    => 'text',
                'title'   => esc_html__( 'Project Category Slug', 'ranbron' ),
                'default' => 'project-cats',
            ),
            array(
                'id'       => $shortname . '_project_cpt_single',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Single Page', 'ranbron' ),
                'desc' => esc_html__( 'Do you want singular item page for this Custom post type. eg: It makes sense to have a Portfolio item single page with more details about that item. But it makes less sense to have single item page for testimonials. Note: Sometimes theme needs to be re-activated for this change to take effect.', 'ranbron' ),
                'default'  => true
            ),
        )
    );
}*/
} // is_array($ranbron_fw_cpt)


    return $sections;

    }
}

