<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package ranbron
 */
?>

<footer class="footer">
<?php

	$total = ranbron_fw_get_option('footer_sidebars', '5');

	if ( ( is_active_sidebar( 'footer-1' ) ||
		   is_active_sidebar( 'footer-2' ) ||
		   is_active_sidebar( 'footer-3' ) ||
		   is_active_sidebar( 'footer-4' ) ) && $total > 0 ) {
		   $BTcols = 3;
		   if ( $total == 4) $BTcols = 3; if ( $total == 3) $BTcols = 4; if ( $total == 2) $BTcols = 6; if ( $total == 1) $BTcols = 12;

?>

	<?php if( $total == '5') { /* lets show theme specific widget layout */ ?>

		<div class="thm-container">
			<div class="row">
				<div class="clearfix col-md-3 footer-widget-1">
					<?php dynamic_sidebar( 'footer-1' ); ?>
				</div><!-- /.col-md-3 -->
				<div class="clearfix col-md-2 footer-widget-2">
					<?php dynamic_sidebar( 'footer-2' ); ?>
				</div><!-- /.col-md-2 -->
				<div class="clearfix col-md-3 footer-widget-3">
					<?php dynamic_sidebar( 'footer-3' ); ?>
				</div><!-- /.col-md-3 -->
				<div class="clearfix col-md-4 footer-widget-4">
					<?php dynamic_sidebar( 'footer-4' ); ?>
				</div><!-- /.col-md-4 -->
			</div><!-- /.row -->
		</div>
	<?php
	}
	else { ?>
	<div class="thm-container">
		<div class="row">

				<?php $i = 0; while ( $i < $total ) { $i++; ?>
					<?php if ( is_active_sidebar( 'footer-' . $i ) ) { ?>
						<div class="clearfix col-md-<?php print esc_attr($BTcols); ?> col-sm-6 footer-widget-<?php print esc_attr($i); ?>">
				            <?php dynamic_sidebar( 'footer-' . $i ); ?>
						</div>
			        <?php } ?>
				<?php } // End WHILE Loop ?>


		</div><!-- /.row -->
	</div><!-- /.thm-container -->
	<?php } ?>
	<?php } // End IF Statement ?>
</footer><!-- /.footer -->
<section class="footer-bottom text-center">
	<div class="thm-container">
				<?php if( ranbron_fw_get_option('footer_left', 1) ) {
					echo do_shortcode( wp_kses(ranbron_fw_get_option('footer_left_text'), ranbron_tt_allowed_tags()));
					} else {
						bloginfo(); ?> &copy; <?php echo date( 'Y' ) . esc_html__( ' All Rights Reserved.', 'ranbron' );
				} ?>
	</div><!-- /.thm-container -->
</section><!-- /.footer-bottom -->

</div><!-- /#page-wrapper -->
<a href="#" class="scrollup"></a>

<div class="search_area zoom-anim-dialog mfp-hide" id="vb-search">
    <div class="search_box_inner">
        <h3><?php esc_html_e( 'Search', 'ranbron' ); ?></h3>
        <form role="search" method="get" class="search-form clearfix" action="<?php echo esc_url(home_url( '/' )); ?>">
	        <div class="input-group">
	        <input type="search" class="search-field form-control"
	            placeholder="<?php echo esc_attr_x( 'Search ...', 'placeholder', 'ranbron' ) ?>"
	            value="<?php echo get_search_query() ?>" name="s"
	            title="<?php echo esc_attr_x( 'Search for:', 'label', 'ranbron' ) ?>" />
	            <span class="input-group-btn">
	                <button class="btn btn-default" type="submit"><i class="icon icon-Search"></i></button>
	            </span>
        </div>
        </form>
    </div>
</div>

<?php wp_footer(); ?>

</body>

</html>